<?php
/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/
?>
<div class="post">
	<h2 class="title"><?php echo $category_name?></h2>
	<?php
		foreach($videos as $video) {
	?>
	<div class="video_thumb">						
		<div class="video_thumbnail">
			<?php $image_link = $this->Image->makeThumbnail($video['Video']['source'],$video['Video']['video_id'],$video['Video']['image_url']); ?>
			<?php echo $html->link(
				$this->Html->image($image_link), array(
						'controller' => 'videos',
						'action' => 'view',
						'video-title' => $video['Video']['machine_name'],
						'video-id' => $video['Video']['id']
					),array('escape' => false)
			);?>
		</div>
		<div class="video_title">
			<?php echo $html->link(
			$video['Video']['name'], array(
					'controller' => 'videos',
					'action' => 'view',
					'video-title' => $video['Video']['machine_name'],
					'video-id' => $video['Video']['id']
				)
			);
			?>
		</div>
		<div class="video_seconds">Seconds : <?php echo $video['Video']['video_timing'];?></div>
		<div class="video_views">Views : <?php echo $video['Video']['viewed'];?></div>
	</div>
	<?php
		}
	?>
	<div class="clear"></div>
</div>
<div class="pagination">
	<!-- Shows the page numbers -->
	<?php
		if(isset($page_name) && $page_name == "video_by_category") {
			$this->Paginator->options(array
				('url'=> array(
					'controller' => 'categories', 
					'action' => 'video_by_category',
					'category-name' => $video['Category']['machine_name'],
					'category-id' => $video['Category']['id']
			)));
		}
		else if(isset($page_name) && $page_name == "recent") {
			$this->Paginator->options(array
				('url'=> array(
					'controller' => 'videos', 
					'action' => 'videos_by_type','recent'					
			)));
		}
		else if(isset($page_name) && $page_name == "most_viewed") {
			$this->Paginator->options(array
				('url'=> array(
					'controller' => 'videos', 
					'action' => 'videos_by_type','most_viewed'
			)));
		}
		else if(isset($page_name) && $page_name == "search_results") {
			$this->Paginator->options(array
				('url'=> array(
					'controller' => 'videos', 
					'action' => 'search_results',
					'keyword' => $this->params['keyword']
			)));
		}
	?>	
	<?php echo $this->Paginator->prev(__('previous',true), null, null, array('class' => 'disabled')); ?>	
	<?php echo $this->Paginator->numbers(); ?>
	<!-- Shows the next and previous links -->
	<?php echo $this->Paginator->next(__('next',true), null, null, array('class' => 'disabled')); ?>
	<!-- prints X of Y, where X is current page and Y is number of pages -->
	( <?php __('pages');?> <?php echo $this->Paginator->counter(); ?> )
</div>	